import React from "react";

export default function Tabs({ tabs, activeTab, onTabChange }) {
  return (
    <div className="flex border-b border-gray-800">
      {tabs.map((tab) => (
        <button
          key={tab.id}
          onClick={() => onTabChange(tab.id)}
          className={`
            px-4 py-3 text-sm font-medium transition-colors focus:outline-none
            ${
              activeTab === tab.id
                ? "text-orange-500 border-b-2 border-orange-500"
                : "text-gray-400 hover:text-gray-200 hover:bg-gray-900"
            }
          `}
        >
          {tab.label}
        </button>
      ))}
    </div>
  );
}
